 ; Bldg: draw one.
 ; Copyright 1997 by Rocket Software
 ; 
 (DEFUN C:BLDG ( / blip aa cc bb dd htp lengph wdthp)
  (setvar "cmdecho" 0)
  (if (null (tblsearch "ltype" "hidden"))
      (command "linetype" "load" "hidden" "acad" ""))
  (setvar "cmdecho" 0)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
 ; Get start point and dimensions.
  (setq ul (getpoint "Start point: "))
  (setq width (getdist ul "\nWidth: "))
  (setq lengph (getdist ul "\nLength: "))
  (setq height (getdist ul "\nHeight: "))
  (setq eaveht (getdist ul "\nEave Height: "))
  (setq ovrhng (getdist ul "\nOverhang: "))
  (setq tabwid (getdist ul "\nTab width: "))
 ; Calculate other three foundation corners, draw base.
  (setq ll (polar ul (* pi 1.5) lengph))
  (setq lr (polar ll 0 width))
  (setq ur (polar lr (* pi 0.5) lengph))
  (command "pline" ul ll lr ur ul "")
 ; Upper wall.
  (setq uwul (polar ul (/ pi 2) height))
  (setq uwur (polar ur (/ pi 2) height))
  (command "pline" ul uwul uwur ur ul "")
 ; Lower wall.
  (setq lwll (polar ll (* pi 1.5) height))
  (setq lwlr (polar lr (* pi 1.5) height))
  (command "pline" ll lwll lwlr lr ll "")
 ; East wall.
  (setq ewur (polar ur 0 height))
  (setq ewlr (polar lr 0 height))
  (setq epeak (polar (polar ewlr (/ pi 2) (/ lengph 2.0)) 0 eaveht))
  (setq roofwid (distance epeak ewlr))
  (command "pline" ur ewur epeak ewlr lr ur "")
 ; West wall.
  (setq wwul (polar ul pi height))
  (setq wwll (polar ll pi height))
  (setq wpeak (polar (polar wwll (/ pi 2) (/ lengph 2.0)) pi eaveht))
  (command "pline" ul wwul wpeak wwll ll ul "")
 ; South roof section.
  (setq roofwid (+ roofwid (* 2 ovrhng)))
  (setq lroofll (polar lwll (* pi 1.5) roofwid))
  (setq lrooflr (polar lwlr (* pi 1.5) roofwid))
  (command "pline" lwll lroofll lrooflr lwlr lwll "")
 ; Underside of eave bend line.
  (setq lleave (polar lwll (* pi 1.5) ovrhng))
  (setq lreave (polar lwlr (* pi 1.5) ovrhng))
  (command "line" lleave lreave "")
  (command "change" "l" "" "p" "ltype" "hidden" "")
 ; North roof section.
  (setq urooful (polar uwul (* pi 0.5) roofwid))
  (setq uroofur (polar uwur (* pi 0.5) roofwid))
  (command "pline" uwul urooful uroofur uwur uwul "")
 ; Underside of eave bend line.
  (setq uleave (polar uwul (* pi 0.5) ovrhng))
  (setq ureave (polar uwur (* pi 0.5) ovrhng))
  (command "line" uleave ureave "")
  (command "change" "l" "" "p" "ltype" "hidden" "")
 ; Now add the tabs.
  (setq tabdiag (* (sqrt 2) tabwid))
 ; West wall upper tab.
  (setq wwutr (polar ul (* pi 0.75) tabdiag))
  (setq wwutl (polar wwul (* pi 0.25) tabdiag))
  (command "pline" ul wwutr wwutl wwul ul "")
  (setq tab1 (entlast))
 ; West wall upper roof tab.
  (setq angg (angle wwul wpeak))
  (setq wrtabr (polar wwul (- angg (/ pi 4)) tabdiag))
  (setq wrtabl (polar wpeak (- angg (* pi 0.75)) tabdiag))
  (command "pline" wwul wrtabr wrtabl wpeak wwul "")
  (setq tab2 (entlast))
 ; Now make the other 6.
  (command "mirror" tab1 "" wpeak epeak "")
  (setq tab3 (entlast))
  (command "mirror" tab2 "" wpeak epeak "")
  (setq tab4 (entlast))
 ; Get points for horizontal mirroring.
  (setq hmirr1 (polar ul 0 (/ width 2)))
  (setq hmirr2 (polar ll 0 (/ width 2)))
  (command "mirror" tab1 tab2 tab3 tab4 "" hmirr1 hmirr2 "")
 ; Roof ridge tab.
  (setq rooftabl (polar urooful (* pi 0.25) tabdiag))
  (setq rooftabr (polar uroofur (* pi 0.75) tabdiag))
  (command "pline" urooful rooftabl rooftabr uroofur urooful "")
 ; Reset and end.
  (setvar "blipmode" blip)
 (princ))